/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.servlet.util;

import com.ibm.hwmca.fw.servlet.pmod.task.PanelModelTaskPortal;
import com.ibm.hwmca.fw.servlet.pmod.task.PmTaskPortalLifeCycleEvent;
import com.ibm.hwmca.fw.servlet.pmod.task.PmTaskPortalLifeCycleListener;
import com.ibm.hwmca.fw.servlet.pmod.task.PmTaskPortalPanelStackEvent;
import com.ibm.hwmca.fw.servlet.util.HMCSession;
import com.ibm.hwmca.fw.util.Trace;
import java.awt.Dimension;

public class TaskWindowPositionManager {
    private static final String TRACE_MASKT = "XTIFWPMT";
    private static final String POSITION_MANAGER_ATTRIBUTE_IN_HMC_SESSION = "util.taskWinPosMgr";
    private static final String WINDOW_POSITION_ATTRIBUTE_IN_PORTAL = "util.taskWinPos";
    private static final String WINDOW_POSITION_SLOT_ATTRIBUTE_IN_PORTAL = "util.taskWinPosSlot";
    private static final int DEFAULT_SCREEN_WIDTH = 1024;
    private static final int DEFAULT_SCREEN_HEIGHT = 768;
    private HMCSession hmcSession;
    private WindowPosition[] predefinedPositions;
    private PanelModelTaskPortal[] owningPortals;
    private TaskEndingListener listener;
    private int cascadeSequence;

    private TaskWindowPositionManager(HMCSession hmcSession) {
        this.hmcSession = hmcSession;
    }

    public static synchronized TaskWindowPositionManager getTaskWindowPositionManager(HMCSession hmcSession) {
        TaskWindowPositionManager manager = (TaskWindowPositionManager)hmcSession.getSessionAttribute(POSITION_MANAGER_ATTRIBUTE_IN_HMC_SESSION);
        if (manager == null) {
            manager = new TaskWindowPositionManager(hmcSession);
            hmcSession.setSessionAttribute(POSITION_MANAGER_ATTRIBUTE_IN_HMC_SESSION, manager);
        }
        return manager;
    }

    private void initializePredefinedPositions(HMCSession hmcSession) {
        this.predefinedPositions = new WindowPosition[10];
        this.owningPortals = new PanelModelTaskPortal[10];
        this.listener = new TaskEndingListener();
        this.predefinedPositions[0] = new WindowPosition(250, 170);
        this.predefinedPositions[1] = new WindowPosition(90, 135);
        this.predefinedPositions[2] = new WindowPosition(65, 210);
        this.predefinedPositions[3] = new WindowPosition(360, 135);
        this.predefinedPositions[4] = new WindowPosition(400, 220);
        this.predefinedPositions[5] = new WindowPosition(4, 50);
        this.predefinedPositions[6] = new WindowPosition(424, 27);
        this.predefinedPositions[7] = new WindowPosition(4, 275);
        this.predefinedPositions[8] = new WindowPosition(225, 275);
        this.predefinedPositions[9] = new WindowPosition(424, 271);
        int screenWidth = hmcSession.getAvailableScreenWidth();
        int screenHeight = hmcSession.getAvailableScreenHeight();
        if (screenWidth != -1 && screenHeight != -1 && (screenWidth != 1024 || screenHeight != 768)) {
            for (int i = 0; i < this.predefinedPositions.length; ++i) {
                WindowPosition pos = this.predefinedPositions[i];
                if (screenWidth != 1024) {
                    pos.setX((int)((double)pos.getX() / 1024.0 * (double)screenWidth));
                }
                if (screenHeight == 768) continue;
                pos.setY((int)((double)pos.getY() / 768.0 * (double)screenHeight));
            }
        }
    }

    private synchronized void claimSlot(int i, PanelModelTaskPortal portal) {
        this.owningPortals[i] = portal;
        portal.setAttribute(WINDOW_POSITION_SLOT_ATTRIBUTE_IN_PORTAL, new Integer(i));
        portal.addLifeCycleListener(this.listener);
        Trace.trace(TRACE_MASKT, "Claiming window position slot " + i + " for portal with id " + portal.getTaskId() + " in session " + portal.getHMCSession().getSessionId());
    }

    private synchronized void relinquishSlot(PanelModelTaskPortal portal) {
        Integer slotInt = (Integer)portal.getAttribute(WINDOW_POSITION_SLOT_ATTRIBUTE_IN_PORTAL);
        if (slotInt == null) {
            return;
        }
        this.owningPortals[slotInt.intValue()] = null;
        portal.removeLifeCycleListener(this.listener);
        portal.removeAttribute(WINDOW_POSITION_SLOT_ATTRIBUTE_IN_PORTAL);
        Trace.trace(TRACE_MASKT, "Relinquishing window position slot " + slotInt + " for portal with id " + portal.getTaskId() + " in session " + portal.getHMCSession().getSessionId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WindowPosition getWindowPosition(PanelModelTaskPortal portal) {
        WindowPosition windowPosition = (WindowPosition)portal.getAttribute(WINDOW_POSITION_ATTRIBUTE_IN_PORTAL);
        if (windowPosition != null) {
            return windowPosition;
        }
        if (portal.isEmbedded()) {
            windowPosition = new WindowPosition(0, 0);
            portal.setAttribute(WINDOW_POSITION_ATTRIBUTE_IN_PORTAL, windowPosition);
            return windowPosition;
        }
        TaskWindowPositionManager taskWindowPositionManager = this;
        synchronized (taskWindowPositionManager) {
            int screenHeight;
            if (this.predefinedPositions == null) {
                this.initializePredefinedPositions(portal.getHMCSession());
            }
            for (int i = 0; i < this.predefinedPositions.length; ++i) {
                if (this.owningPortals[i] != null) continue;
                this.claimSlot(i, portal);
                windowPosition = (WindowPosition)this.predefinedPositions[i].clone();
                portal.setAttribute(WINDOW_POSITION_ATTRIBUTE_IN_PORTAL, windowPosition);
                return windowPosition;
            }
            int cascade = this.cascadeSequence++;
            if (this.cascadeSequence == 20) {
                this.cascadeSequence = 0;
            }
            int column = cascade / 5;
            int row = cascade % 5;
            HMCSession hmcSession = portal.getHMCSession();
            int screenWidth = hmcSession.getAvailableScreenWidth();
            if (screenWidth == -1) {
                screenWidth = 1024;
            }
            if (screenWidth > 500) {
                screenWidth -= 400;
            }
            if ((screenHeight = hmcSession.getAvailableScreenHeight()) == -1) {
                screenHeight = 768;
            }
            if (screenHeight > 500) {
                screenHeight -= 400;
            }
            int x = screenWidth / 4 * column;
            int y = screenHeight / 5 * row;
            windowPosition = new WindowPosition(x, y);
            portal.setAttribute(WINDOW_POSITION_ATTRIBUTE_IN_PORTAL, windowPosition);
            return windowPosition;
        }
    }

    public void setWindowPosition(PanelModelTaskPortal portal, int x, int y) {
        WindowPosition windowPosition = (WindowPosition)portal.getAttribute(WINDOW_POSITION_ATTRIBUTE_IN_PORTAL);
        if (windowPosition != null) {
            windowPosition.setX(x);
            windowPosition.setY(y);
        } else {
            windowPosition = new WindowPosition(x, y);
            portal.setAttribute(WINDOW_POSITION_ATTRIBUTE_IN_PORTAL, windowPosition);
        }
    }

    public void windowMovedTo(PanelModelTaskPortal portal, int x, int y) {
        this.relinquishSlot(portal);
        WindowPosition windowPosition = (WindowPosition)portal.getAttribute(WINDOW_POSITION_ATTRIBUTE_IN_PORTAL);
        if (windowPosition == null) {
            throw new IllegalStateException("No window position assigned");
        }
        windowPosition.setX(x);
        windowPosition.setY(y);
    }

    public WindowPosition getCenteredWindowPosition(PanelModelTaskPortal portal, PanelModelTaskPortal parent) {
        int y;
        WindowPosition parentPosition = (WindowPosition)parent.getAttribute(WINDOW_POSITION_ATTRIBUTE_IN_PORTAL);
        if (parentPosition == null) {
            throw new IllegalStateException("No window position assigned to parent");
        }
        Dimension subjectWindowSize = portal.getWindowSize();
        Dimension parentWindowSize = parent.getWindowSize();
        int leftIndent = (parentWindowSize.width - subjectWindowSize.width) / 2;
        int topIndent = (parentWindowSize.height - subjectWindowSize.height) / 2;
        int x = parentPosition.getX() + leftIndent;
        if (x < 0) {
            x = 0;
        }
        if ((y = parentPosition.getY() + topIndent) < 0) {
            y = 0;
        }
        this.relinquishSlot(portal);
        WindowPosition windowPosition = new WindowPosition(x, y);
        portal.setAttribute(WINDOW_POSITION_ATTRIBUTE_IN_PORTAL, windowPosition);
        return windowPosition;
    }

    private class TaskEndingListener
    implements PmTaskPortalLifeCycleListener {
        private TaskEndingListener() {
        }

        public void taskTermination(PmTaskPortalLifeCycleEvent event) {
            TaskWindowPositionManager.this.relinquishSlot((PanelModelTaskPortal)event.getSource());
        }

        public void modelEnQueued(PmTaskPortalPanelStackEvent event) {
        }

        public void modelDeQueued(PmTaskPortalPanelStackEvent event) {
        }
    }

    public class WindowPosition
    implements Cloneable {
        private int x;
        private int y;

        WindowPosition(int x, int y) {
            this.x = x;
            this.y = y;
        }

        void setX(int x) {
            this.x = x;
        }

        void setY(int y) {
            this.y = y;
        }

        public int getX() {
            return this.x;
        }

        public int getY() {
            return this.y;
        }

        public Object clone() {
            try {
                return (WindowPosition)super.clone();
            }
            catch (CloneNotSupportedException e) {
                return null;
            }
        }
    }
}

